<#

This PowerShell script was developed to reduce annoyances and distractions
in Microsoft Windows 11. For proper viewing, read this file with an editor
that uses a fixed font such as Consolas Regular or Courier New Regular.
Notepad is recommended.

The script was developed through trial and error, experimentation, internet
searches and knowledge from previous Microsoft operating systems. These fixes
are likely temporary due to continuous changes by Microsoft. Operating system
updates might break the changes that this script applies.

The script might fail to run due to a restrictive execution policy. To fix
the problem, open powershell.exe as administrator and issue the following
command:

    Set-ExecutionPolicy -Scope CurrentUser -ExecutionPolicy Bypass
    Type "a" when prompted and press <Enter>

Certain commands in the script affect only the current user (signed in user)
while others affect machine policy (every user). Therefore the script must
be run as administrator.

How to run the script as administrator:

Open a command prompt (cmd.exe) as administrator and issue the following
command:

    powershell.exe -file <path-to-file>
    where <path-to-file> is the actual path to the file.

e.g.	powershell.exe -file C:\Users\Tester\Desktop\annoyances.ps1

A system reboot is recommended at the end.

All commands tested good on Windows 11 Pro 25H2.

Device under test: Lenovo ThinkPad T14 Gen 3
                   Intel Core i5

This line is a separator between commands for easier reading:
# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

The undo commands are commented out with a "#" character.

How to delete a Registry key for current user:
Remove-Item -Path "HKCU:\<path>" -Recurse -Force

How to restart the explorer.exe process, PowerShell:
Get-Process -Name explorer | Stop-Process; Start-Process explorer.exe

How to stop a running Windows service, PowerShell:
Stop-Service -Name "<Display name>"
or
Stop-Service -Name "<Service name>"

e.g.	Stop-Service -Name "Windows Update"
e.g.	Stop-Service -Name wuauserv

e.g.	Stop-Service -Name "Print Spooler"
e.g.	Stop-Service -Name Spooler

How to stop and disable a running Windows service, PowerShell:
Stop-Service -Name "<Service name>";Set-Service -Name "<Service name>" -StartupType  Disabled -Status stopped

e.g.	Stop-Service -Name wuauserv;Set-Service -Name wuauserv -StartupType  Disabled -Status stopped
e.g.	Stop-Service -Name Spooler;Set-Service -Name Spooler -StartupType  Disabled -Status stopped

+----------------------------------------------+
| Line item template - use for standardization |
+----------------------------------------------+

# <nn>
# <description of command intent>
# result: <fail/ success>
Write-Host "<console message>" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
<actual PowerShell command>

# Undo command
# result: <fail/ success>
# <actual PowerShell command>

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

+----------------------------------------------+
| Line item template - use for standardization |
+----------------------------------------------+

P. Henry
2026-01-03
Developed in USA
henrynet.org

#>

# Start script

# Set title bar label
$host.UI.RawUI.WindowTitle = "Annoyances Handling"

# Insert blank line in console
Write-Host ""

Write-Host "The commands run at 5 second intervals without user interaction." -ForegroundColor black -BackgroundColor yellow
Write-Host "Ctrl + C to abort or close window to quit. Read the comments in" -ForegroundColor black -BackgroundColor yellow
Write-Host "the script to determine whether the changes are appropriate for" -ForegroundColor black -BackgroundColor yellow
Write-Host "your environment. Proceed only if you wish to make such changes." -ForegroundColor black -BackgroundColor yellow

Write-Host ""
pause
Write-Host ""


# 01
# Always show scroll bars in Notepad instead of disappearing (thin) scroll bars
# result: success
Write-Host "Show scroll bars in Notepad" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
Set-ItemProperty -Path "HKCU:\Control Panel\Accessibility" -Name "DynamicScrollbars" -Value 0

# Undo command
# result: success
# Set-ItemProperty -Path "HKCU:\Control Panel\Accessibility" -Name "DynamicScrollbars" -Value 1

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 02
# Show full context menu in File Explorer (right-click menu)
# result: success
Write-Host "Show full context menu in File Explorer" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
New-Item -Path "HKCU:\Software\Classes\CLSID\{86ca1aa0-34aa-4e8b-a509-50c905bae2a2}\InprocServer32" -Value "" -Force | Out-Null

# Undo command
# Restores the "Show more options" menu item on the context menu
# result: success
# Remove-Item -Path "HKCU:\Software\Classes\CLSID\{86ca1aa0-34aa-4e8b-a509-50c905bae2a2}" -Recurse -Force

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 03
# Set Taskbar alignment to left instead of center
# result: success
Write-Host "Set Taskbar alignment to left" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
Set-ItemProperty -Path "HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Advanced" -Name "TaskbarAl" -Value 0 -Type DWord

# Undo command
# Set Taskbar alignment to Center instead of Left
# result: success
# Set-ItemProperty -Path "HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Advanced" -Name "TaskbarAl" -Value 1 -Type DWord

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 04
# Set scroll bars (verticle and horizontal) so they are thicker than default
# The factory default value is -255 (formula: -15 x 17 = -255)
# A higher value gives thicker scroll bars
Write-Host "Increase thickness of scroll bars" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
Set-ItemProperty -Path "HKCU:\Control Panel\Desktop\WindowMetrics" -Name "ScrollHeight" -Value -305
Set-ItemProperty -Path "HKCU:\Control Panel\Desktop\WindowMetrics" -Name "ScrollWidth" -Value -305

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 05
# Show extensions for known file types
# result: success
Write-Host "Show extensions for known file types" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
reg add HKCU\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Advanced /v HideFileExt /t REG_DWORD /d 0 /f | Out-Null

# Undo command
# result: success
# reg add HKCU\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Advanced /v HideFileExt /t REG_DWORD /d 1 /f | Out-Null

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 06
# Disable AutoPlay for removable drives
# result: success
Write-Host "Disable AutoPlay for removable drives" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers" -Name "DisableAutoPlay" -Value 1

# Undo command
# result: success
# Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\AutoplayHandlers" -Name "DisableAutoPlay" -Value 0

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 07
# Set sound scheme to no sounds
# result: success
Write-Host "Set sound scheme to no sounds" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""

# This code obtained from google.com
# Set the active sound scheme to "No Sounds" in the registry
Set-ItemProperty -Path "HKCU:\AppEvents\Schemes" -Name "(Default)" -Value ".None"

# Clear all individual event sound paths to apply the change immediately
Get-ChildItem -Path "HKCU:\AppEvents\Schemes\Apps" | 
    Get-ChildItem | 
    Get-ChildItem | 
    Where-Object { $_.PSChildName -eq ".Current" } | 
    Set-ItemProperty -Name "(Default)" -Value ""

# Undo command: Control Panel > Sound > Sounds tab > Sound Scheme > Windows Default

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 08
# Disable Windows startup sound
# result: success
Write-Host "Disable Windows startup sound" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""

# Part 1 of 2
Set-ItemProperty -Path "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI\BootAnimation" -Name "DisableStartupSound" -Value 1

# Part 2 of 2
Set-ItemProperty -Path "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\EditionOverrides" -Name "UserSetting_DisableStartupSound" -Value 1

# Undo command: Control Panel > Sound > Sounds > Play Windows Startup sound
# result: success
# <actual PowerShell command>

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 09
# Uninstall Windows Web Experience Pack
# result: success
Write-Host "Uninstall Windows Web Experience Pack" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
Get-AppxPackage -allusers | Where-Object {$_.Name -Like '*WebExperience*'} | Remove-AppxPackage -ErrorAction Continue

# Undo command
# result: <fail/ success>
# <actual PowerShell command>

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 10
# Disable news and interests
# result: success
Write-Host "Disable News and Interests" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
reg add "HKLM\Software\Policies\Microsoft\Dsh" /v "AllowNewsAndInterests" /t REG_DWORD /d 0 /f | Out-Null

# Undo command
# result: <fail/ success>
# reg add "HKLM\Software\Policies\Microsoft\Dsh" /v "AllowNewsAndInterests" /t REG_DWORD /d 1 /f | Out-Null

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 11
# Disable search box suggestions
# result: success
Write-Host "Disable search box suggestions" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
New-Item -Path "HKCU:\Software\Policies\Microsoft\Windows\Explorer" -Force | Out-Null
Set-ItemProperty -Path "HKCU:\Software\Policies\Microsoft\Windows\Explorer" -Name "DisableSearchBoxSuggestions" -Value 1 -Type Dword -Force

# Get-Process -Name explorer | Stop-Process; Start-Process explorer.exe
# Stop-Process -Name explorer

# Undo command
# result: <fail/ success>
# <actual PowerShell command>

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 12
# Disable the lock screen
# result: success
Write-Host "Disable lock screen" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
reg add HKLM\SOFTWARE\Policies\Microsoft\Windows\Personalization /v NoLockScreen /t REG_DWORD /d 1 /f | Out-Null

# Undo command
# result: <fail/ success>
# <actual PowerShell command>

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 13
# Disable Windows Spotlight
# (picture is used instead)
# result: success
Write-Host "Turn off Windows Spotlight" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
New-ItemProperty -Path "HKCU:\Software\Policies\Microsoft\Windows\CloudContent" -Name "DisableSpotlightCollectionOnDesktop" -Value 1 -PropertyType DWORD -Force | Out-Null

# Undo command
# result: <fail/ success>
# <actual PowerShell command>

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 14
# Disable "Let's finish setting up your device"
# result: <fail/ success>
Write-Host "Disable 'Let's finish setting up your device'" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
New-Item -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\UserProfileEngagement" -Force | Out-Null
New-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\UserProfileEngagement" -Name "ScoobeSystemSettingEnabled" -Value 0 -PropertyType DWORD -Force | Out-Null

# Undo command
# result: <fail/ success>
# <actual PowerShell command>

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 15
# Set power plan to never sleep
# result: success
Write-Host "Set power plan to never sleep" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
powercfg /change standby-timeout-ac 0
powercfg /change standby-timeout-dc 0
powercfg /change monitor-timeout-ac 0
powercfg /change monitor-timeout-dc 0

# Undo command
# result: <fail/ success>
# <actual PowerShell command>

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# 16
# Disable hibernation
# Check hibernation status: powercfg /a
# result: success
Write-Host "Disable hibernation" -ForegroundColor black -BackgroundColor yellow
Write-Host ""
Start-Sleep -seconds 5
# pause
Write-Host ""
powercfg /hibernate off

# Undo command
# result: <fail/ success>
# <actual PowerShell command>

# _/\_^_/\_^_/\_^_/\_^_/\_^_/\_^

# Part 2 of x
# reg add "HKLM\Software\Policies\Microsoft\Dsh" /v "AllowNewsAndInterests" /t REG_DWORD /d 0 /f

# Write-Host ""
Write-Host "End"
Write-Host ""
Write-Host "A system reboot is recommended."
Write-Host ""
pause
Write-Host ""
